% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{ddpcr-class}
\alias{ddpcr}
\alias{ddpcr-class}
\title{Class \code{"ddpcr"}}
\description{
A class specifically designed to contain results from droplet digital PCR
experiments. Data is represented as matrix, where each column describes
different experiment. Type of data in all columns is specified in
slot \code{"type"}.
}
\details{
Possible \code{type} values of \code{adpcr} objects:
\enumerate{
 \item{\code{"fluo"}: fluorescence of each droplet,}
 \item{\code{"nm"}: number of molecules in each droplet,}
 \item{\code{"np"}: status (positive (1) or negative(0)) of each droplet,}
 \item{\code{"tnp"}: total number of positive droplets in the reaction
 (single value per each reaction, not per droplet).}}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\code{"matrix"} containing data from all droplets. See Description.}

\item{\code{n}}{Object of class \code{"integer"} equal to the number of droplets in each
experiment.}

\item{\code{threshold}}{\code{"numeric"} value giving the threshold. Droplets equal or
bigger than threshold are counted as positive.}

\item{\code{type}}{Object of class \code{"character"} defining type of data. See Details.}
}}
\examples{
ddpcr_fluo <- sim_ddpcr(m = 10, n = 20, times = 5, fluo = list(0.1, 0))
plot(ddpcr_fluo)

ddpcr <- sim_ddpcr(m = 10, n = 20, times = 5)
}
\author{
Michal Burdukiewicz.
}
\seealso{
Ploting and managment: \code{\link{bind_dpcr}},
\code{\link{extract_dpcr}}, \code{\link{plot_vic_fam}}.

Simulation: \code{\link{sim_ddpcr}}.

Array digital PCR: \code{\linkS4class{adpcr}}.
}
\keyword{classes}

