% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\docType{methods}
\name{moments-methods}
\alias{moments}
\alias{moments,dpcr-method}
\alias{moments,matrix-method}
\alias{moments,numeric-method}
\alias{moments-methods}
\title{Calculate Moments of Poisson Distribution}
\usage{
moments(input)
}
\arguments{
\item{input}{a vector with two elements (the first element is treated as 
a number of positive partitions and the second as a number of total partitions) 
or a matrix with two columns (first columns contains numbers of 
positive partitions and the second total numbers of total partitions)
or an object of class \code{\linkS4class{dpcr}} .}
}
\value{
A data frame with four columns: name of the experiment, 
name of the replicate, method of computation (theoretical or empirical), 
name of the moment and the value of the moment. The theoretical moments are 
computed using the lambda value and the empirical using the sample values.
}
\description{
Computes moments of a Poisson distribution. The calculations are based on 
values of positive and total partitions or the theoretical lambda value.
}
\note{
Four first moments of a Poisson distribution.

Mean : \eqn{\lambda}{lambda}.

Variance: \eqn{\lambda}{lambda}.

Skewness: \eqn{\sqrt{\lambda}}{lambda^(-0.5)}.

Kurtosis: \eqn{\frac{1}{\lambda}}{lambda^(-1)}.
}
\examples{
# moments for 100 positive partitions of 765 total partitions
moments(c(100, 765))

# calculate moments for an array digital PCR
moments(six_panels)

}
\author{
Michal Burdukiewicz.
}
\keyword{kurtosis}
\keyword{mean}
\keyword{moments}
\keyword{skewness}
\keyword{variance}

