% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manip.r
\name{slice}
\alias{slice}
\alias{slice_}
\title{Select rows by position.}
\usage{
slice(.data, ...)

slice_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Integer row values}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\description{
Slice does not work with relational databases because they have no
intrinsic notion of row order. If you want to perform the equivalent
operation, use \code{\link{filter}()} and \code{\link{row_number}()}.
}
\examples{
slice(mtcars, 1L)
slice(mtcars, n())
slice(mtcars, 5:n())

by_cyl <- group_by(mtcars, cyl)
slice(by_cyl, 1:2)

# Equivalent code using filter that will also work with databases,
# but won't be as fast for in-memory data. For many databases, you'll
# need to supply an explicit variable to use to compute the row number.
filter(mtcars, row_number() == 1L)
filter(mtcars, row_number() == n())
filter(mtcars, between(row_number(), 5, n()))
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{arrange_}}; \code{\link{filter}},
  \code{\link{filter_}}; \code{\link{mutate}},
  \code{\link{mutate_}}, \code{\link{transmute}},
  \code{\link{transmute_}}; \code{\link{rename}},
  \code{\link{rename_}}, \code{\link{select}},
  \code{\link{select_}}; \code{\link{summarise}},
  \code{\link{summarise_}}, \code{\link{summarize}},
  \code{\link{summarize_}}
}

