% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{select_if}
\alias{select_if}
\title{Select columns using a predicate}
\usage{
select_if(.data, .predicate, ...)
}
\arguments{
\item{.data}{A local tbl source.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The columns for which \code{.predicate} is
or returns \code{TRUE} will be summarised or mutated.}

\item{...}{Additional arguments passed to \code{.predicate}.}
}
\description{
This verb is analogous to \code{\link{summarise_if}()} and
\code{\link{mutate_if}()} in that it lets you use a predicate on
the columns of a data frame. Only those columns for which the
predicate returns \code{TRUE} will be selected.
}
\details{
Predicates can only be used with local sources like a data frame.
}
\examples{
iris \%>\% select_if(is.factor)
iris \%>\% select_if(is.numeric)
iris \%>\% select_if(function(col) is.numeric(col) && mean(col) > 3.5)
}

