% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-funs.R
\name{funs}
\alias{funs}
\title{Create a list of function calls}
\usage{
funs(..., .args = list())
}
\arguments{
\item{...}{<\code{\link[=dplyr_data_masking]{data-masking}}> A list of functions
specified by:
\itemize{
\item Their name, \code{"mean"}
\item The function itself, \code{mean}
\item A call to the function with \code{.} as a dummy argument,
\code{mean(., na.rm = TRUE)}
}

The following notations are \strong{not} supported, see examples:
\itemize{
\item An anonymous function, \code{function(x) mean(x, na.rm = TRUE)}
\item An anonymous function in \pkg{purrr} notation, \code{~mean(., na.rm = TRUE)}
}}

\item{.args, args}{A named list of additional arguments to be added to all
function calls. As \code{funs()} is being deprecated, use other methods to
supply arguments: \code{...} argument in \link[=summarise_at]{scoped verbs} or make
own functions with \code{\link[purrr:partial]{purrr::partial()}}.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}

\code{funs()} is deprecated; please use \code{list()} instead. We deprecated this
function because it provided a unique way of specifying anonymous functions,
rather than adopting the conventions used by purrr and other packages
in the tidyverse.
}
\examples{
funs("mean", mean(., na.rm = TRUE))
# ->
list(mean = mean, mean = ~ mean(.x, na.rm = TRUE))

funs(m1 = mean, m2 = "mean", m3 = mean(., na.rm = TRUE))
# ->
list(m1 = mean, m2 = "mean", m3 = ~ mean(.x, na.rm = TRUE))
}
\keyword{internal}
