% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftr.R
\name{ftr}
\alias{ftr}
\title{Footer}
\usage{
ftr(txt1, frmt1 = frmt(fontfamily = "", fontface = "plain", fontsize = 8, col
  = "black", linespace = 0.75), date = TRUE,
  pagelayout.obj = pagelayout(dtype = "portrait", margins = c(1, 0.5)),
  pgtxt2 = "page", pagenum = NULL)
}
\arguments{
\item{txt1}{A vector of text to be placed on bottom right of footer}

\item{frmt1}{style sheet data type frmt for text on bottom left}

\item{date}{Boolean, should today's date be placed in bottom center of page}

\item{pagelayout.obj}{Tells footer what type of page dprint is working with.  Has separate margins to allow for extra space between table presentation}

\item{pgtxt2}{Text to be appended to page number. To suppress numbering, make NULL}

\item{pagenum}{Didn't want parameter here, I wanted pagenum to be passed down the calls stack "eval.parent(pagenum, 1)" here is the only way I could get to work ~ carlin}
}
\description{
dprint is to be designed so that users can define custom functions to present footer on page.  This is the out of box footer.
}
\examples{
\donttest{
longtable1 <- rdesc(15, 7)
longtable2 <- rdesc(7, 4)
h <- expression(hdr("Multiple Page Report",
                pagelayout.obj=pagelayout(dtype="landscape", margins=c(.75, .5))))
f <- expression(ftr("R Package tabulaR",
                pagelayout.obj=pagelayout(dtype="landscape", margins=c(.75, .5))
                , pagenum=eval.parent(pagenum, 1)
                ))
               
 pdf("longtable1.pdf", height=8.5, width=11)
    dp <- dprint(fmla= group+level~ `This is a Control`:(Mean1 + Variance1) +
    Treatment:(Mean2 + Variance2)+p.value,
          data=longtable1, showmargins=TRUE, dtype="landscape",
          newpage=TRUE, pagenum=1, margins=1,
          f.hdr=h, f.ftr=f
          )
   
   dprint(fmla= group+level~ `This is a Control`:(Mean1 + Variance1) + 
   Treatment:(Mean2 + Variance2)+p.value,
          data=longtable2, showmargins=TRUE, dtype="landscape",
          newpage=TRUE, lastcall=dp, # Pick up with page numbering
          margins=1,
          f.hdr=h, f.ftr=f
          )
  x <- rnorm(100)
  y <- rnorm(100)
  f2 <- expression(ftr("R Package tabulaR",
                pagelayout.obj=pagelayout(dtype="landscape", margins=c(.5, .5))
                , pagenum=dp$pagenum+1
                )) }
  # par(mai=c(2,3,2,3))
  \donttest{plot(x,y, main="Scatter Plot X vs. Y")
  eval(f2)
  eval(h)}
  \donttest{par(mfcol=c(1,2), pty="s", bg="grey", mai=c(1,1,1,1))
  plot(density(x), "Distribution of X", xlab="x", bg="blue")
  plot(x,y, main="Scatter Plot X vs. Y")
  eval(f2)
  eval(h)
  dev.off()}
}
