% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js.R
\name{add_js}
\alias{add_js}
\alias{run_js}
\title{Adds a custom JS function}
\usage{
add_js(type, function_text)

run_js(type, ...)
}
\arguments{
\item{type}{name of the function}

\item{function_text}{JS function definition, this should be an anonymous
function accepting exactly one argument}

\item{...}{arguments to pass to the function, those will be combined to a
list and end up as an array in JS, unnamed parameters will be available via
params[0..], named parameters can also be used with params.name}
}
\description{
Adds the given JS function definition to the current shiny web
app.

Before adding anything the code will be parsed with V8 if the package is
available on your machine. If package is available and parsing fails, an
error will be thrown.

After successfully adding a function it can be used with run_js.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    add_js(type="addValues", "function(params) {
      alert('Result is: ' + (parseInt(params[0]) + parseInt(params[1])));
    }"),
    add_js(type="myName", "function(params) {
      alert('My name is ' + params.name);
    }"),
    actionButton("btn1", "Add Values"),
    actionButton("btn2", "What's my name?")
  ),
  server = function(input, output) {
    observeEvent(input$btn1, run_js(type = "addValues", 17, 25))
    observeEvent(input$btn2, run_js(type = "myName", name = "Paul"))
  }
)

}
}
\author{
richard.kunze
}
