% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/est_conc.R
\name{est_conc}
\alias{est_conc}
\title{Estimates concentration given an scluminex object}
\usage{
est_conc(x, df, fanalyte = "analyte", fmfi = "median", dilution = 1,
    one.curve = FALSE, level = 0.95)
}
\arguments{
\item{x}{a \code{scluminex} object.}

\item{df}{input \code{data.frame} with the analyte and median
fluorescence intensity variables.}

\item{fanalyte}{name of the field with the analyte information.
Default 'analyte'.}

\item{fmfi}{name of the field with the mfi (response) information.
Default 'median'.}

\item{dilution}{numeric value of the dilution that must be used for
the estimation of the concentration.}

\item{one.curve}{logical according if only one curve must be used for
estimation.}

\item{level}{numeric value, confidence level, required. Default 0.95.}
}
\value{
Input \code{data.frame} with the following merged variables:
\itemize{
\item{\code{log10.fitted.conc}}{, log10 fitted concentration}
\item{\code{log10.fitted.conc.se}}{, log10 standard error of the log10
fitted concentration}
\item{\code{dilution}}{, dilution to be applied to the samples}
\item{\code{dil.fitted.conc}}{, diluted fitted concentration
in original scale}
\item{\code{dil.lb.conc}}{, diluted fitted lower bound concentration
in original scale}
\item{\code{dil.ub.conc}}{, diluted fitted upper bound concentration
in original scale}
\item{\code{warning}}{, warning message (if necessary)}
}
}
\description{
Given a \code{scluminex} object with standard curve information
and a \code{data.frame} with response values add to the original
dataset the concentration data.
}
\details{
Given a \code{\link{scluminex}} object and a \code{data.frame} with
analyte and MFI information adds the concentration information to the
dataset (concentration, standard error of the concentration and a
warning variable). The MFI data will be transformed into log10(MFI).
The method utilized is the Delta method of \code{\link{invest}} function.

Merging variables are defined in the \code{fanalyte} and \code{fmi}
arguments of the function.

If only one standard curve is fitted for several analytes \code{one.curve}
argument must be specified to \code{TRUE} and \code{scluminex} must have
only one analyte information. The same \code{scluminex} information will
be used for all analytes of the \code{df} \code{data.frame}.

If one standard curve is fitted by each analyte \code{one.curve} must
be \code{FALSE}, so the function will merge each model of the \code{scluminex}
object with the corresponding analyte of the \code{df} argument.
}
\examples{
# Load data and fit models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]
sdf <- data_selection(dat, ecdata)$plate_1

igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
            lfct="SSl4", bkg="ignore", fmfi="mfi", verbose=FALSE)

# Data to estimate concentration
concdf <- sdf$positive

# Dilution factor 1
est_conc(igmodels, concdf, fmfi="mfi", dilution = 1)

# Dilution factor 2
est_conc(igmodels, concdf, fmfi="mfi", dilution = 2)
}

