% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{analyses}
\alias{analyses}
\title{Function \code{analyses}}
\usage{
analyses(plan, datasets)
}
\arguments{
\item{plan}{workflow plan data frame of analysis methods.
The commands in the \code{command} column must
have the \code{..dataset..} wildcard where the datasets go.
For example, one command could be \code{lm(..dataset..)}. Then,
the commands in the output will include \code{lm(your_dataset_1)},
\code{lm(your_dataset_2)}, etc.}

\item{datasets}{workflow plan data frame with instructions
to make the datasets.}
}
\value{
an evaluated workflow plan data frame of analysis instructions
}
\description{
Generate a workflow plan data frame to
analyze multiple datasets using multiple methods of analysis.
}
\examples{
datasets <- workplan(
  small = simulate(5),
  large = simulate(50))
methods <- workplan(
  regression1 = reg1(..dataset..),
  regression2 = reg2(..dataset..))
analyses(methods, datasets = datasets)
}
\seealso{
\code{\link{summaries}},
 \code{\link{make}}, \code{\link{workplan}}
}
