% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_ui.R
\name{built}
\alias{built}
\title{List all the built targets (non-imports) in the cache.}
\usage{
built(path = getwd(), search = TRUE, cache = drake::get_cache(path = path,
  search = search, verbose = verbose), verbose = TRUE, jobs = 1)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{drake cache. See \code{\link{new_cache}()}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{whether to print console messages}

\item{jobs}{number of jobs/workers for parallel processing}
}
\value{
Character vector naming the built targets in the cache.
}
\description{
Targets are listed in the workflow plan
data frame (see \code{\link{drake_plan}()}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Load drake's canonical example.
make(my_plan) # Run the project, build all the targets.
built() # List all the cached targets (built objects and files).
# For file targets, only the fingerprints/hashes are stored.
})
}
}
\seealso{
\code{\link{cached}}, \code{\link{loadd}},
\code{link{imported}}
}
