% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_plans.R
\name{reduce_by}
\alias{reduce_by}
\title{Reduce multiple groupings of targets}
\usage{
reduce_by(plan, ..., prefix = "target", begin = "", op = " + ",
  end = "", pairwise = TRUE)
}
\arguments{
\item{plan}{workflow plan data frame of prespecified targets}

\item{...}{Symbols, columns of \code{plan} to define target groupings
passed to \code{dplyr::group_by()}.
A \code{\link[=reduce_plan]{reduce_plan()}} call is applied for each grouping.
Groupings with all \code{NA}s in the selector variables are ignored.}

\item{prefix}{character, prefix for naming the new targets.
Suffixes are generated from the values of the columns
specified in \code{...}.}

\item{begin}{character, code to place at the beginning
of each step in the reduction}

\item{op}{binary operator to apply in the reduction}

\item{end}{character, code to place at the end
of each step in the reduction}

\item{pairwise}{logical, whether to create multiple
new targets, one for each pair/step in the reduction (\code{TRUE}),
or to do the reduction all in one command.}
}
\description{
Perform several calls to \code{\link[=reduce_plan]{reduce_plan()}}
based on groupings from columns in the plan,
and then row-bind the new targets to the plan.
}
\examples{
plan <- drake_plan(
  data = get_data(),
  informal_look = inspect_data(data, mu = mu__),
  bayes_model = bayesian_model_fit(data, prior_mu = mu__)
)
plan <- evaluate_plan(plan, rules = list(mu__ = 1:2), trace = TRUE)
gather_by(plan, mu___from, gather = "dplyr::bind_rows")
gather_by(plan, mu__, mu___from, prefix = "x")
reduce_by(plan, mu___from, begin = "list(", end = ")", op = ", ")
reduce_by(plan, mu__, mu___from)
}
\seealso{
reduce_plan, gather_plan, gather_by
}
