% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{eager_load_target}
\alias{eager_load_target}
\title{Load a target right away (internal function)}
\usage{
eager_load_target(target, cache, namespace, envir, verbose)
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE}, then
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{namespace}{optional character string,
name of the \code{storr} namespace to read from.}

\item{envir}{environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: also print checks and cache info.
\item \code{3}: also print any potentially missing items.
\item \code{4}: also print imports and writes to the cache.
}}
}
\description{
This function is only exported
to make active bindings work safely.
It is not actually a user-side function.
}
\keyword{internal}
