% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-plan.R
\name{file_out}
\alias{file_out}
\title{Declare output files and directories.}
\usage{
file_out(...)
}
\arguments{
\item{...}{Character vector, paths to files and directories.}
}
\value{
A character vector of declared output file or directory paths.
}
\description{
\code{file_in()} marks individual files
(and whole directories) that your targets create.
}
\examples{
\dontrun{
isolate_example("Contain side effects", {
# The `file_out()` and `file_in()` functions
# just takes in strings and returns them.
file_out("summaries.txt")
# Their main purpose is to orchestrate your custom files
# in your workflow plan data frame.
suppressWarnings(
  plan <- drake_plan(
    out = write.csv(mtcars, file_out("mtcars.csv")),
    contents = read.csv(file_in("mtcars.csv"))
  )
)
plan
# drake knows "\\"mtcars.csv\\"" is the first target
# and a dependency of `contents`. See for yourself:
make(plan)
file.exists("mtcars.csv")
# You can also work with entire directories this way.
# However, in `file_out("your_directory")`, the directory
# becomes an entire unit. Thus, `file_in("your_directory")`
# is more appropriate for subsequent steps than
# `file_in("your_directory/file_inside.txt")`.
suppressWarnings(
  plan <- drake_plan(
    out = {
      dir.create(file_out("dir"))
      write.csv(mtcars, "dir/mtcars.csv")
    },
    contents = read.csv(file.path(file_in("dir"), "mtcars.csv"))
  )
)
plan
make(plan)
# See the connections that the file relationships create:
# config <- drake_config(plan) # nolint
# vis_drake_graph(config)      # nolint
file.exists("dir/mtcars.csv")
})
}
}
\seealso{
\code{\link[=file_out]{file_out()}}, \code{\link[=knitr_in]{knitr_in()}}, \code{\link[=ignore]{ignore()}}
}
