% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_settings.R
\name{simulate_data}
\alias{simulate_data}
\title{Generate simulation data.}
\usage{
simulate_data(n, ex_setting, f_setting)
}
\arguments{
\item{n}{integer number of samples. For "401k" ex_setting this is ignored
and the whole data set is used.}

\item{ex_setting}{string "normal", "mixture2", "mixture3",
"logistic", "t4", "401k".}

\item{f_setting}{string "plm", "additive", "interaction".}
}
\value{
list containing y, x, z. Additionally contains the population
nuisance parameters evaluated on the data, and the sample version of
the average partial effect.
}
\description{
If ex_setting = "401k" then 401k data set is used for (X,Z). Otherwise:
}
\details{
Z ~ N_{9}(0,Sigma),
where Sigma_{jj} = 1, Sigma_{jk} = corr for all j not equal to k.
X = m(Z) + s(Z)*ex
where m and sigma are step functions of z_1 and z_3 respectively.
Y = f(X,Z) + N(0,1)
}
\examples{
simulate_data(100, "normal", "plm")
}
