% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.drda}
\alias{plot.drda}
\title{Model fit plotting}
\usage{
\method{plot}{drda}(x, ...)
}
\arguments{
\item{x}{\code{drda} object as returned by the \code{link[drda]{drda}} function.}

\item{...}{other \code{drda} objects or parameters to be passed to the plotting
functions. See 'Details'.}
}
\value{
No return value.
}
\description{
Plot maximum likelihood curves fitted with \code{drda}.
}
\details{
This function provides a scatter plot of the observed data, overlaid with the
maximum likelihood curve fit.
If multiple fit objects are given, they will all be placed in the same plot.

Accepted plotting arguments are:

\describe{
\item{base}{character string with the base used to print the values on the
x axis. Accepted values are \code{e} for the natural logarithm (the default),
\code{10} for base 10, and \code{2} for base 2.}
\item{col}{curve color(s). By default, up to 9 color-blind friendly
colors are provided.}
\item{xlab, ylab}{axis labels.}
\item{xlim, ylim}{the range of x and y values with sensible defaults.}
\item{level}{level of confidence intervals. Set to zero or a negative value
to disable confidence intervals.}
\item{legend}{custom labels for the legend model names.}
}
}
