% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_tools.R
\name{variable_importance}
\alias{variable_importance}
\title{Calculate a simple measure of 'importance' for each feature.}
\usage{
variable_importance(forest, decay.exponent = 2, max.depth = 4)
}
\arguments{
\item{forest}{The trained forest.}

\item{decay.exponent}{A tuning parameter that controls the importance of split depth.}

\item{max.depth}{Maximum depth of splits to consider.}
}
\value{
A list specifying an 'importance value' for each feature.
}
\description{
A simple weighted sum of how many times feature i was split on at each depth in the forest.
}
\examples{
n <- 50
p <- 2
X <- matrix(rnorm(n * p), n, p)
Y <- X + matrix(rnorm(n * p), ncol=p)
drf.forest <- drf(X = X, Y = Y, splitting.rule = "FourierMMD", num.features = 10)

# Calculate the 'importance' of each feature.
variable_importance(drf.forest)

}
