% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{loglik.dmm}
\alias{loglik.dmm}
\title{Evaluate the log-likelihood of a drifting Markov Model}
\usage{
\method{loglik}{dmm}(x, sequences, ncpu = 2)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{sequences}{A character vector or a list of character vectors representing the sequence}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A list of log-likelihood (numeric)
}
\description{
Evaluate the log-likelihood of a drifting Markov Model
}
\examples{
data(lambda, package = "drimmR")
sequence <- c("a","g","g","t","c","g","a","t","a","a","a")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
loglik(dmm,sequence)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}
}
\author{
Annthomy Gilles, Alexandre Seiller
}
