% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{maintainability}
\alias{maintainability}
\title{Maintainability function}
\usage{
maintainability(
  x,
  k1 = 0L,
  k2,
  upstates,
  output_file = NULL,
  plot = FALSE,
  ncpu = 2
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{k1}{Start position (default value=0) :  a positive integer giving the start position along the sequence from which the maintainabilities of the DMM should be computed, such that \code{k1}<\code{k2}}

\item{k2}{End position :  a positive integer giving the end position along the sequence until which the maintainabilities of the DMM should be computed, such that \code{k2}>\code{k1}}

\item{upstates}{Character vector of the subspace working states among the state space vector such that upstates < s}

\item{output_file}{(Optional) A file containing matrix of maintainability probabilities (e.g, "C:/.../MAIN.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of maintainability probabilities by position)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector of length k + 1 giving the values of the maintainability for the period \eqn{[0 \ldots k]}
}
\description{
Maintainability of a system at time \eqn{k \in N} is the probability that the system is repaired up to time \eqn{k},
given that is has failed at time \eqn{k=0}.
}
\details{
Consider a system (or a component) System whose possible states during its evolution in time are
\eqn{E = \{1 \ldots s \}}. Denote by \eqn{U = \{1 \ldots s_1 \}} the subset of operational states of the system (the upstates) and by \eqn{D =\{s_{1}+1 \ldots s \}} the subset of failure states (the down states), with 0 < s1 < s(obviously, \eqn{E = U \cup D and U \cap D = \emptyset, U \neq \emptyset, D \neq \emptyset}). One can think of the states of U as
different operating modes or performance levels of the system, whereas the states of D can be seen as failures of the systems with different modes.
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'),
init.estim = "freq", fit.method="sum")
k1 <- 1
k2 <- 200
upstates <- c("c","t")  # vector of working states
maintainability(dmm,k1,k2,upstates,plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}
}
\author{
Alexandre Seiller
}
