#' Flying Etiquette Survey Data
#'
#' This is a modified version of the Flying Etiquette Survey data behind the story: 41 percent of flyers say it's rude to recline your seat on an airplane.
#'
#' @format a dataframe 1040 obs. and 28 columns, which are:
#' \describe{
#' \item{respondent_id}{respondentid}
#'   \item{travel_frequency}{how often do you travel by plane?}
#'   \item{seat_recline}{do you ever recline your seat when you fly?}
#'   \item{height}{how tall are you?}
#'   \item{children_under_18}{do you have any children under 18?}
#'   \item{two_armrests}{in a row of three seats, who should get to use the two arm rests?}
#'   \item{middle_armrest}{in a row of two seats, who should get to use the middle arm rest?}
#'   \item{window_shade}{who should have control over the window shade?}
#'   \item{moving_to_unsold_seat}{is it rude to move to an unsold seat on a plane?}
#'   \item{talking_to_seatmate}{generally speaking, is it rude to say more than a few words to the stranger sitting next to you on a plane?}
#'   \item{getting_up_on_6_hour_flight}{on a 6 hour flight from nyc to la, how many times is it acceptable to get up if you're not in an aisle seat?}
#'   \item{obligation_to_reclined_seat}{is it rude to recline your seat on a plane?}
#'   \item{eliminate_reclining_seats}{given the opportunity, would you eliminate the possibility of reclining seats on planes entirely?}
#'   \item{switch_for_friends}{is it rude to ask someone to switch seats with you in order to be closer to friends?}
#'   \item{switch_for_family}{is it rude to ask someone to switch seats with you in order to be closer to family?}
#'   \item{wake_passenger_bathroom}{is it rude to wake a passenger up if you are trying to go to the bathroom?}
#'   \item{wake_passenger_walk}{is it rude to wake a passenger up if you are trying to walk around?}
#'   \item{baby_on_plane}{in general, is it rude to bring a baby on a plane?}
#'   \item{unruly_children}{in general, is it rude to knowingly bring unruly children on a plane?}
#'   \item{electronics_violation}{have you ever used personal electronics during take off or landing in violation of a flight attendant's direction?}
#'   \item{smoking_violation}{have you ever smoked a cigarette in an airplane bathroom when it was against the rules?}
#'   \item{gender}{gender}
#'   \item{age}{age}
#'   \item{household_income}{household income}
#'   \item{education}{education}
#'   \item{location_census_region}{location (census region)}
#'   \item{survey_type}{type of the survey}
#' }
#'
#' @source https://github.com/fivethirtyeight/data/tree/15f210532b2a642e85738ddefa7a2945d47e2585/flying-etiquette-survey
#' @source https://fivethirtyeight.com/features/airplane-etiquette-recline-seat/
#'
#' @examples
#' data(flying)

"flying"

