% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.drord}
\alias{plot.drord}
\title{Print the output of a \code{"drord"} object.}
\usage{
\method{plot}{drord}(
  x,
  treat_labels = c(1, 0),
  dist = "pmf",
  out_labels = if (dist == "pmf") {     x$out_levels } else {    
    x$out_levels[-length(x$out_levels)] },
  ...
)
}
\arguments{
\item{x}{A \code{"drord"} object.}

\item{treat_labels}{Labels for the treatment variables (treat = 1 followed by treat = 0).}

\item{dist}{Which distribution to plot. Valid options are \code{"cdf"} or \code{"pmf"}.}

\item{out_labels}{Labels for the ordered outcome levels. If \code{dist = "cdf"}, the
highest level of outcome will be dropped.}

\item{...}{Other arguments (not used)}
}
\value{
A list with named entries \code{plot} (a \code{ggplot2} object) and \code{plot_data},
the \code{data.frame} from which the plot is made. The latter is included for additional
modifications to the plot that are desired.
}
\description{
Print the output of a \code{"drord"} object.
}
