% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_normal.R
\name{pgo_multiple_normal}
\alias{pgo_multiple_normal}
\title{Probability to go to phase III for multiple endpoints with normally distributed outcomes}
\usage{
pgo_multiple_normal(
  kappa,
  n2,
  Delta1,
  Delta2,
  in1,
  in2,
  sigma1,
  sigma2,
  fixed,
  rho,
  rsamp
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule; vector for both endpoints}

\item{n2}{total sample size for phase II; must be even number}

\item{Delta1}{assumed true treatment effect given as difference in means for endpoint 1}

\item{Delta2}{assumed true treatment effect given as difference in means for endpoint 2}

\item{in1}{amount of information for Delta1 in terms of sample size}

\item{in2}{amount of information for Delta2 in terms of sample size}

\item{sigma1}{standard deviation of first endpoint}

\item{sigma2}{standard deviation of second endpoint}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE Delta1 is used as fixed effect}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
The output of the function \code{pgo_multiple_normal()} is the probability to go to phase III.
}
\description{
This function calculated the probability that we go to phase III, i.e. that results of phase II are promising enough to
get a successful drug development program. Successful means that both endpoints show a statistically significant positive treatment effect in phase III.
}
\keyword{internal}
