% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_time}
\alias{what_time}
\title{What time is it?}
\usage{
what_time(when = NA, seconds = FALSE, sep = ":")
}
\arguments{
\item{when}{Time (as a scalar or vector).
Default: \code{when = NA}. 
Returning \code{Sys.time()}, if \code{when = NA}.}

\item{seconds}{Boolean: Show time with seconds?
Default: \code{seconds = FALSE}.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = ":"}.}
}
\description{
\code{what_time} provides a satisficing version of 
\code{Sys.time()} that is sufficient for most purposes.
}
\details{
\code{what_time} returns either a simple version of 
\code{when} or \code{Sys.time()}  
(in "%H:%M" or "%H:%M:%S" format) 
using current system settings.
}
\examples{
what_time()  

# with vector (of times): 
ts <- c("2020-01-14 01:02:03 CET", "2020-12-31 14:15:16")
what_time(ts)
what_time(ts, seconds = TRUE, sep = "_")

}
\seealso{
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
