% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{falsePosPsy_all}
\alias{falsePosPsy_all}
\title{False Positive Psychology data.}
\format{
A table with 78 cases (rows) and 19 variables (columns):
}
\source{
\strong{Articles}

\itemize{

\item Simmons, J.P., Nelson, L.D., & Simonsohn, U. (2011). 
False-positive psychology: Undisclosed flexibility in data collection and analysis 
allows presenting anything as significant. 
\emph{Psychological Science}, \emph{22}(11), 1359--1366. 
doi: \url{https://doi.org/10.1177/0956797611417632}

\item Simmons, J.P., Nelson, L.D., & Simonsohn, U. (2014). 
Data from paper "False-Positive Psychology: 
Undisclosed Flexibility in Data Collection and Analysis 
Allows Presenting Anything as Significant". 
\emph{Journal of Open Psychology Data}, \emph{2}(1), e1. 
doi: \url{https://doi.org/10.5334/jopd.aa} 
}

See files at \url{https://openpsychologydata.metajnl.com/articles/10.5334/jopd.aa/} and 
the archive at \url{https://zenodo.org/record/7664} for original dataset.
}
\usage{
falsePosPsy_all
}
\description{
\code{falsePosPsy_all} is a dataset containing the data from 2 studies designed to 
highlight problematic research practices within psychology.
}
\details{
Simmons, Nelson and Simonsohn (2011) published a controversial article 
with a necessarily false finding. By conducting simulations and 2 simple behavioral experiments, 
the authors show that flexibility in data collection, analysis, and reporting 
dramatically increases the rate of false-positive findings. 

\describe{
  \item{study}{Study ID.}
  \item{id}{Participant ID.}
  \item{aged}{Days since participant was born (based on their self-reported birthday).}
  \item{aged365}{Age in years.}
  \item{female}{Is participant a woman? 1: yes, 2: no.}
  \item{dad}{Father's age (in years).}
  \item{mom}{Mother's age (in years).}
  \item{potato}{Did the participant hear the song 'Hot Potato' by The Wiggles? 1: yes, 2: no.}
  \item{when64}{Did the participant hear the song 'When I am 64' by The Beatles? 1: yes, 2: no.}      
  \item{kalimba}{Did the participant hear the song 'Kalimba' by Mr. Scrub? 1: yes, 2: no.}
  \item{cond}{In which condition was the participant? 
  control: Subject heard the song 'Kalimba' by Mr. Scrub; 
  potato: Subject heard the song 'Hot Potato' by The Wiggles; 
  64: Subject heard the song 'When I am 64' by The Beatles.}
  \item{root}{Could participant report the square root of 100? 1: yes, 2: no.}      
  \item{bird}{Imagine a restaurant you really like offered a 30 percent discount for dining between 4pm and 6pm. 
  How likely would you be to take advantage of that offer? 
  Scale from 1: very unlikely, 7: very likely.}
  \item{political}{In the political spectrum, where would you place yourself? 
  Scale: 1: very liberal, 2: liberal, 3: centrist, 4: conservative, 5: very conservative.}
  \item{quarterback}{If you had to guess who was chosen the quarterback of the year in Canada last year, 
  which of the following four options would you choose? 
  1: Dalton Bell, 2: Daryll Clark, 3: Jarious Jackson, 4: Frank Wilczynski.}      
  \item{olddays}{How often have you referred to some past part of your life as “the good old days”? 
  Scale: 11: never, 12: almost never, 13: sometimes, 14: often, 15: very often.}
  \item{feelold}{How old do you feel? 
  Scale: 1: very young, 2: young, 3: neither young nor old, 4: old, 5: very old.}
  \item{computer}{Computers are complicated machines. 
  Scale from 1: strongly disagree, to 5: strongly agree.}      
  \item{diner}{Imagine you were going to a diner for dinner tonight, how much do you think you would like the food? 
  Scale from 1: dislike extremely, to 9: like extremely.}
  }

See \url{https://bookdown.org/hneth/ds4psy/B-2-datasets-false.html} for codebook and more information.
}
\seealso{
Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t1}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{dt_10}},
\code{\link{exp_num_dt}},
\code{\link{exp_wide}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_AHI_CESD}},
\code{\link{posPsy_long}},
\code{\link{posPsy_p_info}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
