% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_fun.R
\name{theme_empty}
\alias{theme_empty}
\title{A basic and flexible plot theme (using ggplot2 and unikn).}
\usage{
theme_empty(
  font_size = 12,
  font_family = "",
  rel_small = 12/14,
  plot_mar = c(0, 0, 0, 0)
)
}
\arguments{
\item{font_size}{Overall font size. 
Default: \code{font_size = 12}.}

\item{font_family}{Base font family.
Default: \code{font_family = ""}.}

\item{rel_small}{Relative size of smaller text. 
Default: \code{rel_small = 10/12}.}

\item{plot_mar}{Plot margin sizes (on top, right, bottom, left). 
Default: \code{plot_mar = c(0, 0, 0, 0)} (in lines).}
}
\value{
A \bold{ggplot2} theme.
}
\description{
\code{theme_empty} provides an empty (blank) theme 
to use in \bold{ggplot2} commands.
}
\details{
\code{theme_empty} shows nothing but the plot panel.

\code{theme_empty} is based on 
\code{theme_nothing} of the \bold{cowplot} package 
and uses  
\code{theme_void} of the \bold{ggplot2} package.
}
\examples{

\donttest{

# Plotting iris dataset (using ggplot2):

library('ggplot2')  # theme_empty() requires ggplot2
   
ggplot(datasets::iris) +
  geom_point(aes(x = Petal.Length, y = Petal.Width, color = Species), size = 4, alpha = 1/2) +
  scale_color_manual(values = c("firebrick3", "deepskyblue3", "olivedrab3")) +
  labs(title = "NOT SHOWN: Title",
       subtitle = "NOT SHOWN: Subtitle", 
       caption = "NOT SHOWN: Data from datasets::iris") +
  theme_empty(plot_mar = c(2, 0, 1, 0))  # margin lines (top, right, bot, left)

}
  
}
\seealso{
\code{cowplot::theme_nothing} is the inspiration and source of this theme.

Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_chars}()},
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()}
}
\concept{plot functions}
