% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{capitalize}
\alias{capitalize}
\title{Capitalize initial characters in strings of text \code{x}.}
\usage{
capitalize(x, n = 1, upper = TRUE, as_text = FALSE)
}
\arguments{
\item{x}{A string of text (required).}

\item{n}{Number of initial characters to convert.
Default: \code{n = 1}.}

\item{upper}{Convert to uppercase?
Default: \code{upper = TRUE}.}

\item{as_text}{Treat and return \code{x} as a text 
(i.e., one character string)? 
Default: \code{as_text = FALSE}.}
}
\value{
A character vector.
}
\description{
\code{capitalize} converts the case of 
each element's (i.e., character string or word in text) 
\code{n} initial characters to \code{upper} or lowercase.
}
\details{
If \code{as_text = TRUE}, the input \code{x} is merged into 
one string of text and the arguments are applied to each word.
}
\examples{
x <- c("Hello world!", "this is a TEST sentence.", "the end.")
capitalize(x)
capitalize(tolower(x))

# Options: 
capitalize(x, n = 3)                  # leaves strings intact
capitalize(x, n = 3, as_text = TRUE)  # treats strings as text
capitalize(x, n = 3, upper = FALSE)   # first n in lowercase

}
\seealso{
\code{\link{caseflip}} for converting the case of all letters; 
\code{\link{words_to_text}} and \code{\link{text_to_words}} for converting character vectors and texts.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
