% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_time}
\alias{what_time}
\title{What time is it?}
\usage{
what_time(when = NA, seconds = FALSE, as_string = TRUE, sep = ":", tz = "")
}
\arguments{
\item{when}{Time (as a scalar or vector).
Default: \code{when = NA}. 
Returning \code{Sys.time()}, if \code{when = NA}.}

\item{seconds}{Boolean: Show time with seconds?
Default: \code{seconds = FALSE}.}

\item{as_string}{Boolean: Return as character string? 
Default: \code{as_string = TRUE}. 
If \code{as_string = FALSE}, a "POSIXct" object is returned.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = ":"}.}

\item{tz}{Time zone.
Default: \code{tz = ""} (i.e., current system time zone,  
see \code{Sys.timezone()}). 
Use \code{tz = "UTC"} for Coordinated Universal Time.}
}
\value{
A character string or object of class "POSIXct".
}
\description{
\code{what_time} provides a satisficing version of 
\code{Sys.time()} that is sufficient for most purposes.
}
\details{
By default, \code{what_time} prints a simple version of 
\code{when} or \code{Sys.time()} 
as a character string (in "%H:%M" or "%H:%M:%S" format) 
using current default system settings.  
If \code{as_string = FALSE}, a "POSIXct" 
(calendar time) object is returned.

The \code{tz} argument allows specifying time zones 
(see \code{Sys.timezone()} for current setting 
and \code{OlsonNames()} for options.) 

However, \code{tz} is merely used to represent the 
times provided to the \code{when} argument. 
Thus, there currently is no active conversion 
of times into other time zones 
(see the \code{now} function of \strong{lubridate} package).
}
\examples{
what_time()  

# with vector (of "POSIXct" objects): 
tm <- c("2020-02-29 01:02:03", "2020-12-31 14:15:16")
what_time(tm)

# with time zone: 
ts <- ISOdate(2020, 12, 24, c(0, 12))  # midnight and midday UTC
t1 <- what_time(when = ts, tz = "Pacific/Honolulu")
t1  # time display changed, due to tz

# return "POSIXct" object(s):
# Same time in differen tz:
t2 <- what_time(as.POSIXct("2020-02-29 10:00:00"), as_string = FALSE, tz = "Pacific/Honolulu")
format(t2, "\%F \%T \%Z (UTF \%z)")
# from string:
t3 <- what_time("2020-02-29 10:00:00", as_string = FALSE, tz = "Pacific/Honolulu")
format(t3, "\%F \%T \%Z (UTF \%z)")

}
\seealso{
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
