% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_gcdg_gsed.R
\name{rename_gcdg_gsed}
\alias{rename_gcdg_gsed}
\title{Rename items from gcdg into gsed lexicon}
\usage{
rename_gcdg_gsed(x, copy = TRUE)
}
\arguments{
\item{x}{A character vector containing item names in the gcdg lexicon}

\item{copy}{A logical indicating whether any unmatches names should
be copied (\code{copy = TRUE}) or set to an empty string.}
}
\value{
A character vector of length \code{length(x)} with gcdg
item names replaced by gsed item name.
}
\description{
Function \code{rename_gcdg_gsed()} translates item names in the
gcdg lexicon to item names in the gsed lexicon.
}
\details{
The gsed-naming convention is as follows. Position 1-3 codes the
instrument, position 4-5 codes the domain, position 6 codes
direct/caregiver/message, positions 7-9 is a item sequence number.

The function currently support ASQ-I (aqi), Barrera-Moncade (bar),
Batelle (bat), Bayley I (by1), Bayley II (by2), Bayley III (by3),
Dutch Development Instrument (ddi), Denver (den), Griffith (gri),
MacArthur (mac), WHO milestones (mds), Mullen (mul), pegboard (peg),
South African Griffith (sgr), Stanford Binet (sbi), Tepsi (tep),
Vineland (vin).

In cases where the domain of the items isn't clear (vin, bar),
the domain is coded as 'xx'.
}
\examples{
from <- c(
  "ag28", "gh2_19", "a14ps4", "b1m157", "mil6",
  "bm19", "a16fm4", "n22", "ag9", "gh6_5"
)
to <- rename_gcdg_gsed(from, copy = FALSE)
to
}
\references{
\url{https://docs.google.com/spreadsheets/d/1zLsSW9CzqshL8ubb7K5R9987jF4YGDVAW_NBw1hR2aQ/edit#gid=0}
}
\author{
Iris Eekhout, Stef van Buuren
}
