\name{gen.mine.data}
\alias{gen.mine.data}
\alias{build.diagonal.model}
\alias{build.input.models}

\title{Generate Data}
\description{Generate data for Monte Carlo experimants}
\usage{
    gen.mine.data(umodel, ymodel, uinput=NULL, sampleT=100, 
    unoise=NULL, usd=1,ynoise=NULL, ysd=1, rng=NULL))
}
\arguments{
    \item{umodel}{Model for input data.}
    \item{ymodel}{Model for output data.}
    \item{sampleT}{Number of periods of data to generate.}
    \item{unoise}{Input noise.}
    \item{usd}{Standard deviationof input noise.}
    \item{ynoise}{Output noise.}
    \item{ysd}{Standard deviation of output noise.}
    \item{rng}{RNG setting.}
}
\value{A TSdata object.}
\details{
    This function generates test data using specified models.
    umodel is used to generate data input data and
    ymodel is used to generate data corresponding output data.
    The result of umodel is used as input to ymodel so the input dimension of
    ymodel should be the output dimension of umodel. Typically the ymodel would
    be degenerate in some of the input variables so the effective inputs 
    are a subset.
    If noise is NULL then an normal noise will be generated by simulate.
    This will be iid N(0,I).
    The RNG will be set first if it is specified. 
    If unoise or ynoise are specified they should be as expected by simulate
    for the specified umodel and ymodel.
    
    This function uses build.input.models which makes a list of univariate 
    models, one for each series in input.data(data) and 
    build.diagonal.model which builds one diagonal model from a list 
    of models returned  by build.input.models. It uses the AR part only.
}

\seealso{
    \code{\link{simulate}}
}

\examples{
    if(is.R()) data("eg1.DSE.data.diff", package="dse1")
    umodel <- build.diagonal.model(
            build.input.models(eg1.DSE.data.diff, max.lag=2))
    z  <- TSdata(output=output.data(eg1.DSE.data.diff), 
                 input = input.data(eg1.DSE.data.diff))
    ymodel <- TSmodel(est.VARX.ls(z, max.lag=3))   
    sim.data <- gen.mine.data(umodel, ymodel)
}
%\keyword{DSE}
\keyword{ts}

