\name{getRNG}
\alias{getRNG}
\alias{getRNG.default}

\title{get the RND and seed from an object}
\description{
Get the random number generator and seed used to generate an object.
}
\usage{
    getRNG(e=NULL)
    \method{getRNG}{default}(e=NULL)
}
\arguments{
    \item{e}{an object generated by simulation (which stored the RNG 
    information).}
}
\value{The random seed and other random number generation information
   used to generate the object. }
\details{Some information about the version is also verified.}
\seealso{
\code{\link{setRNG}},
\code{\link{.Random.seed}}
}
\examples{
\dontrun{
if (require("dse1")) {
  if(is.R()) data("eg1.DSE.data.diff", package="dse1")
  model <- estVARXls(eg1.DSE.data.diff)
  sim <- simulate(model)
  getRNG(sim)
  }
}
}
%\keyword{DSE}
\keyword{ts}
