% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_utility.R
\name{dcop_copula}
\alias{dcop_copula}
\alias{dcop_copula_deriv}
\alias{pcop_copula}
\alias{rcop_copula}
\title{Utility functions}
\usage{
dcop_copula(U, Tau = 0, family = 1, log.p = FALSE)

dcop_copula_deriv(x, U = NULL, family = 1, D = 2)

pcop_copula(U, Tau = 0, family = 1, log.p = FALSE)

rcop_copula(Tau = 0, family = 1)
}
\arguments{
\item{U}{matrix of pseudo observations. Must have two columns.}

\item{Tau}{matrix of Kendall's tau.}

\item{family}{integer, defines the copula family:\cr
\code{1} = Gaussian copula \cr}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
\code{dcop_copula} gives the density, \code{pcop_copula} gives the distribution function for a specified copula and \code{rcop_copula} generates random numbers, with given Tau.
These functions are not written for vector inputs. \code{dcop_copula_deriv} provides a wrapper function for the 'numDeriv' package functions, such that the gradient and hessian of the density can be evaluated.
}
\description{
Internal utility functions for copulae
}
\section{Functions}{
\itemize{
\item \code{dcop_copula_deriv()}: Wrapper function of dcop_copula for usage with 'numDeriv' package

\item \code{pcop_copula()}: distribution function of copula

\item \code{rcop_copula()}: random number generation for copula

}}
\keyword{copula}
\keyword{density}
\keyword{internal}
\keyword{of}
