% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{differencerule}
\alias{differencerule}
\title{Differencerule}
\usage{
differencerule(f_list, tri, deriv_order)
}
\arguments{
\item{f_list}{list of \code{derivs} objects of length \eqn{M}, e.g. \eqn{list(f_1(\cdot), f_2(\cdot),...,f_M(\cdot))}}

\item{tri}{list; created by the function [trind_generator()].}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}
}
\value{
Returns an object of class \code{derivs} for the function \eqn{h(\cdot)}.
}
\description{
Differencerule for derivs objects.
}
\details{
Let \eqn{f_m} be a function defined in [trind()], where \eqn{m \in {1,...,M}}.
Define \eqn{h((x_{n1},x_{n2},...,x_{nK})) = f_1(\cdot) - f_2(\cdot) ... - f_M(x_{n1},x_{n2},...,x_{nK}))}.
In order to get the derivatives of \eqn{h(\cdot)} w.r.t all parameters \eqn{x_{nk}}, the difference rule is applied.
For more details see [trind()] and [trind_generator()].
}
\examples{
A<-matrix(c(1:9)/10, ncol=1)
A_derivs<-list2derivs(list(A, A^0, A^2, A^3, A^4), deriv_order=4)
differencerule(list(A_derivs, A_derivs), trind_generator(1), deriv_order=4) #equal to 0

}
\seealso{
Other derivs: 
\code{\link{chainrule}()},
\code{\link{derivs_transform}()},
\code{\link{ind2joint}()},
\code{\link{list2derivs}()},
\code{\link{productrule}()},
\code{\link{quotientrule}()},
\code{\link{sumrule}()},
\code{\link{trind_generator}()},
\code{\link{trind}()}
}
\concept{derivs}
