% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnormexp.R
\name{dnormexp}
\alias{dnormexp}
\alias{normexp}
\alias{pnormexp}
\alias{qnormexp}
\alias{rnormexp}
\title{Normal-Exponential distribution}
\usage{
dnormexp(
  x,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

pnormexp(
  q,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

qnormexp(p, mu = 0, sigma_v = 1, sigma_u = 1, s = -1, log.p = FALSE)

rnormexp(n, mu = 0, sigma_v = 1, sigma_u = 1, s = -1)
}
\arguments{
\item{x}{numeric vector of quantiles.}

\item{mu}{numeric vector of \eqn{\mu}.}

\item{sigma_v}{numeric vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{numeric vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{integer; \eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional; index matrix for upper triangular, generated by \code{\link{trind_generator}}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{numeric vector of quantiles.}

\item{p}{numeric vector of probabilities.}

\item{n}{positive integer; number of observations.}
}
\value{
\code{dnormexp()} gives the density, \code{pnormexp()} give the distribution function, \code{qnormexp()} gives the quantile function, and \code{rnormexp()} generates random numbers, with given parameters.
\code{dnormexp()} and \code{pnormexp()} return a \code{derivs} object. For more details see \code{\link{trind}} and \code{\link{trind_generator}}.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the normal-exponential distribution
}
\details{
A random variable \eqn{X} follows a normal-exponential distribution if \eqn{X = V + s \cdot U }, where \eqn{V \sim N(\mu, \sigma_V^2)} and \eqn{U \sim Exp(\sigma_U)}.
The density is given by \deqn{f_X(x)=\frac{\sigma_U}{2} \exp \{\sigma_U (s \mu) + \frac{1}{2} \sigma_U^2 \sigma_V^2-\sigma_U (s x) \} 2 \Phi(\frac{1}{\sigma_V} (-s \mu)-\sigma_U \sigma_V+\frac{1}{\sigma_V}(s x)) \qquad,}
where \eqn{s=-1} for production and \eqn{s=1} for cost function. In the latter case the distribution is equivalent to the Exponentially modified Gaussian distribution. 
'
}
\section{Functions}{
\itemize{
\item \code{pnormexp()}: distribution function for the normal-exponential distribution.

\item \code{qnormexp()}: quantile function for the normal-exponential distribution.

\item \code{rnormexp()}: random number generation for the normal-exponential distribution.

}}
\examples{
pdf <- dnormexp(x=5, mu=1, sigma_v=2, sigma_u=3, s=-1)
cdf <- pnormexp(q=5, mu=1, sigma_v=2, sigma_u=3, s=-1)
q <- qnormexp(p=seq(0.1, 0.9, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1)
r <- rnormexp(n=10, mu=1, sigma_v=2, sigma_u=3, s=-1)

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
\seealso{
Other distribution: 
\code{\link{dcomper_mv}()},
\code{\link{dcomper}()},
\code{\link{dnormhnorm}()}
}
\concept{distribution}
