% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_gene_expression.R
\docType{data}
\name{tissue_gene_expression}
\alias{tissue_gene_expression}
\title{Gene expression profiles for 189 biological samples taken from seven different tissue types.}
\format{An object of class \code{list}.}
\source{
\href{https://github.com/genomicsclass/tissuesGeneExpression}{https://github.com/genomicsclass/tissuesGeneExpression}
}
\usage{
data(tissue_gene_expression)
}
\description{
This is a subset of the data provided by the \code{tissuesGeneExpression}
package available from the \code{genomicsclass} GitHub repository. 
The predictors are gene expression measurements from 500 genes that
are a random subset of the original 22,215.
}
\details{
The example dataset is recommended for illustrating
clustering and machine learning techniques.

\itemize{
\item x. The predictors composed of 500 genes. Each row is a gene expression profile and each column is different gene. The column names are the gene symbols.
\item y. The outcomes. A character vector representing the tissue. One of seven tissue types.
}
}
\examples{
data(tissue_gene_expression)
table(tissue_gene_expression$y)
dim(tissue_gene_expression$x)
}
\keyword{datasets}
