% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsos-s3.R
\name{print.outlier.test}
\alias{print.outlier.test}
\title{Print result of test for no adverse shift.}
\usage{
\method{print}{outlier.test}(x, n = 5, ...)
}
\arguments{
\item{x}{A \code{outlier.test} object from a D-SOS test.}

\item{n}{The number of outlier scores to print for each sample.}

\item{...}{Placeholder to be compatible with S3 `print` generic.}
}
\value{
A \pkg{ggplot2} plot with outlier scores and p-value.
}
\description{
Print result of test for no adverse shift.
}
\examples{
\donttest{
set.seed(12345)
os_train <- rnorm(n=3e2)
os_test <- rnorm(n=3e2)
test_to_print <- at_from_os(os_train, os_test)
# Also: pt_from_os(os_train, os_test) for permutation test
test_to_print
}

}
\seealso{
Other s3-method: 
\code{\link{plot.outlier.test}()}
}
\concept{s3-method}
