% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_multiplication.R
\name{d_mat_mult}
\alias{d_mat_mult}
\title{Multiply by D matrix}
\usage{
d_mat_mult(v, k, xd, tf_weighting = FALSE, transpose = FALSE)
}
\arguments{
\item{v}{Vector to be multiplied by D, the discrete derivative matrix.}

\item{k}{Order for the discrete derivative matrix. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{tf_weighting}{Should "trend filtering weighting" be used? This is a
weighting of the discrete derivatives that is implicit in trend filtering;
see details for more information. The default is \code{FALSE}.}

\item{transpose}{Multiply by the transpose of D? The default is \code{FALSE}.}
}
\value{
Product of the discrete derivative matrix D and the input vector \code{v}.
}
\description{
Multiplies a given vector by D, the discrete derivative matrix of a given
order, with respect to given design points.
}
\details{
The discrete derivative matrix of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{D^k_n}. It has
dimension \eqn{(n-k) \times n}. Acting on a vector \eqn{v} of function
evaluations at the design points, denoted \eqn{v = f(x_{1:n})}, it gives
the discrete derivatives of \eqn{f} at the points \eqn{x_{(k+1):n}}:
\deqn{
  D^k_n v = (\Delta^k_n f) (x_{(k+1):n}).
  }
The matrix \eqn{D^k_n} can be constructed recursively as the product of a
diagonally-weighted first difference matrix and \eqn{D^{k-1}_n}; see the
help file for \code{\link[=d_mat]{d_mat()}}, or Section 6.1 of Tibshirani (2020). Therefore,
multiplication by \eqn{D^k_n} or by its transpose can be performed in
\eqn{O(nk)} operations based on iterated weighted differences. See Appendix
D of Tibshirani (2020) for details.

The option \code{tf_weighting = TRUE} performs multiplication by \eqn{W^k_n D^k_n}
where \eqn{W^k_n} is a \eqn{(n-k) \times (n-k)} diagonal matrix with
entries \eqn{(x_{i+k} - x_i) / k}, \eqn{i = 1,\ldots,n-k}. This weighting
is implicit in trend filtering, as the penalty in the \eqn{k}th order trend
filtering optimization problem (with optimization parameter \eqn{\theta})
is \eqn{\|W^{k+1}_n D^{k+1}_n \theta\|_1}. Moreover, this is precisely the
\eqn{k}th order total variation of the \eqn{k}th degree discrete spline
interpolant \eqn{f} to \eqn{\theta}, with knots in \eqn{x_{(k+1):(n-1)}};
that is, such an interpolant satisfies:
\deqn{
  \mathrm{TV}(D^k f) = \|W^{k+1}_n D^{k+1}_n \theta\|_1,
  }
where \eqn{D^k f} is the \eqn{k}th derivative of \eqn{f}. See Section
9.1. of Tibshirani (2020) for more details.
}
\examples{
v = sort(runif(10))
as.vector(d_mat(2, 1:10) \%*\% v)
d_mat_mult(v, 2, 1:10) 
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 6.1.
}
\seealso{
\code{\link[=discrete_deriv]{discrete_deriv()}} for discrete differentiation at arbitrary query
points, \code{\link[=b_mat_mult]{b_mat_mult()}} for multiplying by the extended discrete derivative
matrix, and \code{\link[=d_mat]{d_mat()}} for constructing the discrete derivative matrix.
}
