% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elim.R
\name{elim}
\alias{elim}
\title{Reduction of a relation}
\usage{
elim(rel, xnb)
}
\arguments{
\item{rel}{The relation to reduce, an object of class bcaspec.}

\item{xnb}{Identification number of the variable to eliminate.}
}
\value{
r The reduced relation
}
\description{
This function works on a relation defined on a product of two variables or more.  Having fixed a variable to eliminate from the relation,  the reduced product space is determined and the corresponding reduced bca is computed.This operation is also called "marginalization".
}
\examples{
 
# We construct a relation between two variables to show marginalization.
wr_tt <- matrix(c(1,rep(0,3),rep(c(1,0),3),0,1,1,1,0,0,
1,0,rep(1,5),0,1,1,0,rep(1,5)), ncol = 4, byrow = TRUE)
colnames(wr_tt) <- c("Wy Ry", "Wy Rn", "Wn Ry", "Wn Rn")
rownames(wr_tt) <- nameRows(wr_tt)
wr_spec = matrix(c(1:8, 0.017344, 0.046656, 
0.004336, 0.199456,0.011664,0.536544,0.049864, 0.134136), 
 ncol = 2, dimnames = list(NULL, c("specnb", "mass"))) 
 wr_infovar = matrix(c(4,5,2,2), ncol = 2, 
 dimnames = list(NULL, c("varnb", "size")) )
wr_rel <- list(tt = wr_tt, con = 0.16, spec=wr_spec,
  infovar = wr_infovar, varnames = c("Roadworks","Rain"),
  valuenames = list( RdWorks = c("Wy", "Wn"), Rain=c("Ry", "Rn") ))
class(wr_rel) <- "bcaspec"
bcaPrint(elim(wr_rel, xnb = 5))
bcaPrint(elim(wr_rel, xnb = 4))
 
}
\author{
Claude Boivin
}
