% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belplauEval.R
\name{belplauEval}
\alias{belplauEval}
\title{Evaluate type I, II errors}
\usage{
belplauEval(
  bel_plau,
  true_order,
  var = "rplau",
  err = "type I",
  is_belplau = TRUE
)
}
\arguments{
\item{bel_plau}{belplau object or a vector whose ordering is compared}

\item{true_order}{a vector representing the true ordering}

\item{var}{="rplau" variable name of the belplau to be used as ordering}

\item{err}{="type I" type of error to be evaluated}

\item{is_belplau}{=TRUE whether bel_plau is a belplau object}
}
\value{
Type I, II, III error by comparing two orderings
}
\description{
Evaluate type I, II errors
}
\examples{
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3, 
byrow = TRUE), m = c(0.2,0.5, 0.3), 
cnames = c("a", "b", "c"), varnames = "x", idvar = 1)
belplau(x)
y <- bca(tt = matrix(c(1,0,0,1,1,1),nrow = 2, 
byrow = TRUE), m = c(0.6, 0.4),  
cnames = c("a", "b", "c"),  varnames = "y", idvar = 1)
xy <- nzdsr(dsrwon(x,y))
z<-belplau(xy,h=ttmatrixPartition(xy$infovar[2],xy$infovar[2]))
belplauEval(z,c(0,1,0))
}
\author{
Peiyuan Zhu
}
