% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathComb.R
\name{transform_math}
\alias{transform_math}
\title{Mathematical transformations for biomarkers}
\usage{
transform_math(markers, transform)
}
\arguments{
\item{markers}{A \code{numeric} data frame that contains the biomarkers.}

\item{transform}{A character string specifying the transformation method to be applied.
Supported methods are: \code{"log"}, \code{"exp"}, \code{"sin"}, \code{"cos"}.}
}
\value{
A \code{numeric} data frame containing the transformed biomarkers.
}
\description{
Applies a selected mathematical transformation (\code{"log"}, \code{"exp"}, \code{"sin"}, or \code{"cos"}) to biomarker data.
}
\examples{
data(laparotomy)
markers <- laparotomy[, -1]
transform_math(markers, transform = "log")

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
