#' An Expansion of the Iris Dataset
#'
#' An expansion of the well-known \code{\link[datasets]{iris}} dataset. Extra
#' variables from a range of classes, modes, types, and factor level lengths,
#' spewed from the imagination of a formal consortium of wild monkeys, have been
#' added to complicate the \code{iris} dataset and provide a stomping grounds to
#' demonstrate the outrageous capabilities of the \code{dtables} package, and
#' test new ones.
#'
#' \describe{
#'   \item{Sepal.Length}{Original iris variable}
#'   \item{Sepal.Width}{Original iris variable}
#'   \item{Petal.Length}{Original iris variable}
#'   \item{Petal.Width}{Original iris variable}
#'   \item{Species}{Original iris variable}
#'   \item{Color}{A factor variable of class character; the color of the flower}
#'   \item{Attractiveness}{A likert scale variable of class integer; the attractiveness of the flower}
#'   \item{LikelyToBuy}{A likert scale variable of class integer with negative values; the likelihood of buying the flower}
#'   \item{Sold}{A dichotomous variable of class logical; whether or not the flower was bought}
#'   \item{Review}{A likert scale variable of class numeric; the customer's review of the flower}
#'   \item{Approval}{A missing values variable of class logical; a spanner in the works}
#'   \item{Date}{A date variable of class Date; the date the flower was bought}
#' }
#'
#'
"iris2"
