% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_Y_refs.R
\name{combine_Y_refs}
\alias{combine_Y_refs}
\title{Row-binds \code{Y} with \code{references} and generates \code{pure_samples}.}
\usage{
combine_Y_refs(Y, references, pure_samples)
}
\arguments{
\item{Y}{Expression matrix.

(Required) Two-dimensional numeric. Must implement \code{as.matrix}.

Each row contains expression measurements for a particular sample. Each columm contains the measurements of the same gene over all individuals. Can either contain just the mixture samples to be deconvolved or both the mixture samples and the reference samples. See \code{pure_samples} and \code{references} for more details.}

\item{references}{Cell-type reference expression matrix.

(Optional) Two-dimensional numeric. Must implement \code{as.matrix}. Must have same number of columns as \code{Y}. Columns must correspond to columns of \code{Y}.

Each row contains expression measurements for a reference profile of a particular cell type. Columns contain measurements of reference profiles of a gene. Optionally may merge this matrix with \code{Y} and use \code{pure_samples} to indicate which rows of \code{Y} are pure samples. If \code{pure_samples} is not specified \code{references} must be specified. In this case each row of \code{references} is assumed to be a distinct cell-type. If both \code{pure_samples} and \code{references} are specified then \code{pure_samples} specifies to which cell-type each row of \code{references} corresponds.}

\item{pure_samples}{The pure sample indicies.

(Optional) List of one-dimensional integer. Must implement \code{as.list}.

The i-th element of the top-level list is a vector of indicies (rows of \code{Y} or \code{references}) that are pure samples of type i. If \code{references} is not specified then this argument identifies which rows of \code{Y} correspond to pure reference samples of which cell-types. If \code{references} is specified then this makes same idenficiation but for the \code{references} matrix instead.}
}
\description{
Row-binds \code{Y} with \code{references} and generates \code{pure_samples}.
}
