% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtps.R
\name{calculate_dtps}
\alias{calculate_dtps}
\title{Produce the Dose Transition Pathways}
\usage{
calculate_dtps(next_dose, cohort_sizes, prev_tox = c(), prev_dose =
    c(), dose_func = applied_crm, ...)
}
\arguments{
\item{next_dose}{An integer value representing the dose to be assigned to the
first cohort of subjects in the pathways.}

\item{cohort_sizes}{A vector of cohort sizes representing the size of the
cohorts to be treated with the recommended dose at each decision point.}

\item{prev_tox}{A vector of previous subject outcomes; 1 indicates toxicity,
0 otherwise.}

\item{prev_dose}{A vector of previous subject doses; The length of prev_dose
must be equal to that of prev_tox.}

\item{dose_func}{A function such as applied_crm which produces an object of
class 'mtd'. To be used for calculation of the next recommended dose for
each pathway permutation.}

\item{...}{Any other arguments to be passed to dose_func; for specific
arguments related to applied_crm see.}
}
\value{
Produces a dataframe containing all possible permutations of outcomes
    for each cohort based on cohort_sizes and the recommended
    doses for such permutations.
}
\description{
calculate_dtps is used to produce the dose transition pathways
    for the continual reassessment method with specified design
    options. These pathways present the possible model recommendations based
    on all permumations of trial outcomes.
}
\examples{
prior  <- c(0.1, 0.2, 0.5)
target <- 0.15
prev_tox <- c(0, 0, 0)
prev_dose <- c(2, 2, 2)
cohort_sizes <- c(2, 3)

next_dose = applied_crm(prior = prior, target = target,
                        tox = prev_tox, level = prev_dose)$mtd

dose_func <- applied_crm

DTP = calculate_dtps(next_dose, cohort_sizes, prev_tox = prev_tox,
                      prev_dose = prev_dose, dose_func = applied_crm,
                      prior = prior, target = target)

}
\keyword{CRM}
\keyword{DTP}
\keyword{dtpcrm}
