% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{comment}
\alias{comment}
\title{Add a generic comment to the dtrackr history graph}
\usage{
comment(
  .data,
  .messages = .defaultMessage(),
  .headline = .defaultHeadline(),
  .type = "info",
  .asOffshoot = (.type == "exclusion"),
  .tag = NULL
)
}
\arguments{
\item{.data}{\itemize{
\item a dataframe which may be grouped
}}

\item{.messages}{\itemize{
\item a character vector of glue specifications. A glue specification can refer to any grouping variables of .data, or any variables defined in the calling environment, the \{.total\} of all rows,
the \{.count\} variable which is the count in each group and \{.strata\} a description of the group
}}

\item{.headline}{\itemize{
\item a glue specification which can refer to grouping variables of .data, or any variables defined in the calling environment, or the \{.total\} variable which is nrow(.data)and \{.strata\}
}}

\item{.type}{\itemize{
\item one of "info","...,"exclusion": used to define formatting
}}

\item{.asOffshoot}{\itemize{
\item do you want this comment to be an offshoot of the main flow (default = FALSE).
}}

\item{.tag}{\itemize{
\item if you want the summary data from this step in the future then give it a name with .tag.
}}
}
\value{
the same .data dataframe with the history graph updated with the comment
}
\description{
A comment can be any kind fo note and is added once for every current grouping as defined by the \code{.message} field. It can be made context specific
by including variables such as \{.count\} and \{.total\} in \code{.message} which refer to the grouped and ungrouped counts at this current stage of the pipeline for example.
It can also pull in any global variable.
}
\examples{
library(dplyr)
iris \%>\% track() \%>\% comment("hello {.total} rows") \%>\% history()
}
