% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_get_as_dot}
\alias{p_get_as_dot}
\title{DOT output}
\usage{
p_get_as_dot(.data, fill = "lightgrey", fontsize = "8", colour = "black", ...)
}
\arguments{
\item{.data}{\itemize{
\item the tracked dataframe
}}

\item{fill}{\itemize{
\item the default node fill colour
}}

\item{fontsize}{\itemize{
\item the default font size
}}

\item{colour}{\itemize{
\item the default font colour
}}

\item{...}{\itemize{
\item not used
}}
}
\value{
a representation of the history graph in \code{Graphviz} dot format.
}
\description{
(advance usage) outputs a dtrackr history graph as a DOT string for rendering with \code{Graphviz}
}
\examples{
library(dplyr)
tmp = iris \%>\% track() \%>\% comment(.tag = "step1") \%>\% filter(Species!="versicolor")
dot = tmp \%>\% group_by(Species) \%>\% comment(.tag="step2") \%>\% p_get_as_dot()
cat(dot)
}
