% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\name{dtree}
\alias{dtree}
\title{Main function for creating different types of decision trees}
\usage{
dtree(formula, data, methods = c("lm", "rpart", "tree", "ctree", "evtree"),
  samp.method = "repeatedcv", tuneLength = 3, bump.rep = 50,
  subset = FALSE, perc.sub = 0.75, weights = NULL, verbose = TRUE)
}
\arguments{
\item{formula}{a formula, with a response to left of ~.}

\item{data}{Data frame to run models on}

\item{methods}{Which tree methods to use. Defaults:
lm, rpart, ctree, evtree. Also can use "rf" for random forests.
Also a FDR pruning method for ctree termed "ctreePrune".
Finally bumping is implemented as methods="bump".}

\item{samp.method}{Sampling method. Refer to caret package trainControl()
documentation. Default is repeated cross-validation. Other options
include "cv" and "boot".}

\item{tuneLength}{Number of tuning parameters to try. Applies to train().
Can also be specified as a vector, with order corresponding to the
order specified in the methods argument.}

\item{bump.rep}{Number of repetitions for bumping}

\item{subset}{Whether to split dataset into training and test sets}

\item{perc.sub}{What fraction of data to put into train dataset. 1-frac.sub
is allocated to test dataset. Defaults to 0.75}

\item{weights}{Optional weights for each case.}

\item{verbose}{Whether to print what method on}
}
\description{
Main function for creating different types of decision trees
}
\examples{
# continuous outcome
#library(MASS) # for boston data
#data(Boston)
#out <- dtree(medv ~., data=Boston,methods=c("lm","rpart","ctree"))
#summary(out)
# plot(out$rpart.out)

# categorical outcome
#library(ISLR)
#data(Default)

#out <- dtree(default ~ ., data=Default,methods=c("lm","rpart"))
#summary(out)
}
