% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtts.R
\name{align}
\alias{align}
\alias{align,data.table,nanotime,nanoduration,nanoduration-method}
\alias{align,data.table,nanotime,missing,missing-method}
\alias{align,data.table,nanotime,nanoduration,missing-method}
\alias{align,data.table,nanotime,missing,nanoduration-method}
\alias{align,data.table,nanotime,nanoperiod,nanoperiod-method}
\alias{align,data.table,nanotime,nanoperiod,missing-method}
\alias{align,data.table,nanotime,missing,nanoperiod-method}
\title{Align a \code{data.table} onto a \code{nanotime} vector}
\usage{
align(x, y, start, end, ...)

\S4method{align}{data.table,nanotime,nanoduration,nanoduration}(
  x,
  y,
  start = as.nanoduration(0),
  end = as.nanoduration(0),
  sopen = FALSE,
  eopen = TRUE,
  func = NULL
)

\S4method{align}{data.table,nanotime,missing,missing}(
  x,
  y,
  start = as.nanoduration(0),
  end = as.nanoduration(0),
  sopen = FALSE,
  eopen = TRUE,
  func = NULL
)

\S4method{align}{data.table,nanotime,nanoduration,missing}(
  x,
  y,
  start = as.nanoduration(0),
  end = as.nanoduration(0),
  sopen = FALSE,
  eopen = TRUE,
  func = NULL
)

\S4method{align}{data.table,nanotime,missing,nanoduration}(
  x,
  y,
  start = as.nanoduration(0),
  end = as.nanoduration(0),
  sopen = FALSE,
  eopen = TRUE,
  func = NULL
)

\S4method{align}{data.table,nanotime,nanoperiod,nanoperiod}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  func = NULL
)

\S4method{align}{data.table,nanotime,nanoperiod,missing}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  func = NULL
)

\S4method{align}{data.table,nanotime,missing,nanoperiod}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  func = NULL
)
}
\arguments{
\item{x}{the \code{data.table} time-series to align from}

\item{y}{the \code{nanotime} vector to align to}

\item{start}{scalar or vector of same length as \code{y} of type
\code{integer64}; \code{start} is added to each element in
\code{y} and it then defines the starting point of the
interval under consideration for the alignment on that
element of \code{y}}

\item{end}{scalar or vector of same length as \code{y} of type
\code{integer64}; \code{start} is added to each element in
\code{y} and it then defines the ending point of the interval
under consideration for the alignment on that element of
\code{y}}

\item{...}{further arguments passed to or from methods.}

\item{sopen}{boolean scalar or vector of same lengths as \code{y}
that indicates if the start of the interval is open or
closed. Defaults to FALSE.}

\item{eopen}{boolean scalar or vector of same lengths as \code{y}
that indicates if the end of the interval is open or
closed. Defaults to TRUE.}

\item{func}{a function taking one argument and which provides an
arbitrary aggregation of its argument; if \code{NULL} then a
function which takes the closest observation is used.}

\item{tz}{scalar or vector of same length as \code{y} of type
character. Only used when the type of \code{start} and
\code{end} is \code{nanoperiod}. It defines the time zone for
the definition of the interval.}
}
\value{
a \code{data.table} time-series of the same length as
    \code{y}; this is a subset of \code{x} with the
    \code{nanotime} index of \code{y}
}
\description{
\code{align} returns the subset of \code{data.table} \code{x} that
aligns on the temporal vector \code{y}
}
\details{
For each element in \code{y}, intervals are created around this
element with \code{start} and \code{end}. All the elements of
\code{x} that fall within this interval are given as argument to
the function \code{func}. The function \code{func} show reduce
this \code{data.frame} to one unique row that will be associated
with the \code{nanotime} value in \code{y}.
}
\examples{
\dontrun{
y <- nanotime((1:10)*1e9)
x <- data.table(index=nanotime((1:10)*1e9), data=1:10)
align(x, y, as.nanoduration(-1e9), as.nanoduration(1e9), colMeans)
}


}
