% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatches.R
\docType{methods}
\name{plotMatches}
\alias{plotMatches}
\title{Plotting matching points}
\usage{
plotMatches(x, timeseries.labels = 1, patterns.labels = NULL, k = 1,
  attr = 1, shift = 0.5, show.dist = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwMatches}}.}

\item{timeseries.labels}{the label or index of the time series.
Default is 1.}

\item{patterns.labels}{a vector with labels of the patterns. If not 
declared the function will plot one alignment for each pattern.}

\item{k}{A positive integer. The index of the last alignment to include in 
the plot. If not declared the function will plot the best match for 
each pattern.}

\item{attr}{An \link[base]{integer} or \link[base]{character} vector 
indicating the attribute for plotting. Default is 1.}

\item{shift}{A number, it shifts the pattern position in the \code{x}
direction. Default is 0.5.}

\item{show.dist}{show the distance for each alignment. Default is FALSE.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting the matching points from   
TWDTW analysis.
}
\examples{
log_fun = logisticWeight(-0.1, 100)
ts = twdtwTimeSeries(MOD13Q1.ts.list)
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
mat1 = twdtwApply(x=ts, y=patt, weight.fun=log_fun, keep=TRUE)

plotMatches(mat1)

plotMatches(mat1, patterns.labels="Soybean", k=4)

plotMatches(mat1, patterns.labels=c("Soybean","Maize"), k=4)

plotMatches(mat1, patterns.labels=c("Soybean","Cotton"), k=c(3,1))

}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{plotPaths}}, 
\code{\link[dtwSat]{plotCostMatrix}},
\code{\link[dtwSat]{plotAlignments}}, and
\code{\link[dtwSat]{plotClassification}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
