% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.spls.errorcv.R
\name{d.spls.errorcv}
\alias{d.spls.errorcv}
\title{Computes the error of a cross validation iteration}
\usage{
d.spls.errorcv(
  cvcal,
  X,
  Y,
  ncomp,
  dspls = "lasso",
  ppnu = 0.9,
  nu2,
  indG,
  gamma
)
}
\arguments{
\item{cvcal}{a numeric vector representing the index of the calibration set to be used in the fitting.}

\item{X}{a numeric matrix.}

\item{Y}{a numeric vector representing the response values.}

\item{ncomp}{a numeric vector of the number of latent numbers to use while computing the errors.}

\item{dspls}{the norm type of the Dual-SPLS regression applied. Default value is \code{lasso}. Options are \code{pls}, \code{LS},
\code{ridge}, \code{GLA}, \code{GLB} and \code{GLC}.}

\item{ppnu}{a positive real value, in \eqn{[0,1]}. \code{ppnu} is the desired
proportion of variables to shrink to zero for each component (see Dual-SPLS methodology).}

\item{nu2}{a positive real value. \code{nu2} is a constraint parameter used in the ridge norm.}

\item{indG}{a numeric vector of group index for each observation. It is used in the cases of the group lasso norms.}

\item{gamma}{a numeric vector of the norm \eqn{\Omega} of each \eqn{w_g} in the case of \code{GLB} norm.}
}
\value{
a numeric vector representing the errors for each fitted model
}
\description{
The function \code{d.spls.errorcv} computes the sum of squared errors of a validation set according to a calibration set \code{cvcal} used
to fit the Dual-SPLS regression. This function is an internal function used in the cross validation procedure in order to determine
the best number of latent variables of any of the Dual-SPLS versions.
}
\seealso{
\link{d.spls.cv},\link{d.spls.lasso}
}
\author{
Louna Alsouki François Wahl
}
\keyword{internal}
