% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.spls.metric.R
\name{d.spls.metric}
\alias{d.spls.metric}
\title{Computes predictions criterias}
\usage{
d.spls.metric(hat.y,real.y)
}
\arguments{
\item{hat.y}{a numeric vector. It represents the fitted response variable for each observation using a Dual-SPLS method.}

\item{real.y}{a numeric vector. It represents the response variable for each observation.}
}
\value{
A \code{list} of the following attributes
\item{RMSE}{the vector of the root mean square error values for each component.}
\item{MAE}{the vector of the mean absolute error values for each component.}
\item{Rsquared}{the vector of the Rsquared values for each component.}
}
\description{
This function computes evaluation metrics commonly used in modelling. It provides the values of the root mean square
error (RMSE), the mean absolute error (MAE) and the Rsquared.
}
\details{
The Root Mean Square Error (RMSE) is the standard deviation of the residuals. It is computed as follows:
\deqn{RMSE=\sqrt{\sum_{i=1}^n \frac{(y_{fi}-y_{ri})^2}{n}}.}

The Mean Absolute Error measures the average magnitude of the errors in a set of predictions,
without considering their direction. It is computed as follows:
\deqn{MAE=\frac{1}{n}\sum_{i=1}^n |y_{fi}-y_{ri}|.}

The Rsquared represents the proportion of the variance for a dependent
variable that's explained by an independent variable in a regresison. It is computed as follows:

\deqn{R2=\frac{\sum_{i=1}^n (y_{fi}-\bar{y})^2}{\sum_{i=1}^n (y_{ri}-\bar{y})^2}.}
Where \eqn{\bar{y}=\frac{1}{n}\sum_{i=1}^n y_{fi}}. Note that \eqn{y_f} are the fitted values and \eqn{y_r} are the real ones.
}
\examples{
### load dual.spls library
library(dual.spls)
### constructing the simulated example
n <- 100
p <- 50
nondes <- 20
sigmaondes <- 0.5
data=d.spls.simulate(n=n,p=p,nondes=nondes,sigmaondes=sigmaondes)

X <- data$X
y <- data$y

#fitting the Dual-SPLS lasso model

ncomplasso <- d.spls.cv(X=X,Y=y,ncomp=10,dspls="lasso",ppnu=0.9,nrepcv=20,pctcv=75)
mod.dspls.lasso <- d.spls.lasso(X=X,y=y,ncp=ncomplasso,ppnu=0.9,verbose=TRUE)

predmetric= d.spls.metric(mod.dspls.lasso$fitted.values,y)

#Error plots
plot(1:ncomplasso,predmetric$RMSE,
main=("Root mean squares error values"),xlab='Number of components',ylab='Errors',col='blue',pch=19)
lines(1:ncomplasso,predmetric$RMSE,col='blue')
points(1:ncomplasso,predmetric$MAE,col='red',pch=19)
lines(1:ncomplasso,predmetric$MAE,col='red')
points(1:ncomplasso,predmetric$R2,col='green',pch=19)
lines(1:ncomplasso,predmetric$R2,col='green')
legend("topright", legend = c("RMSE", "MAE", "R2"), bty = "n",
 cex = 0.8, col = c("blue", "red","green"), lty = c(1,1,1))
}
\author{
Louna Alsouki François Wahl
}
