% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\docType{methods}
\name{log}
\alias{log}
\alias{log,dual-method}
\alias{logb}
\alias{logb,dual,numeric-method}
\alias{logb,numeric,dual-method}
\alias{logb,dual,dual-method}
\alias{log10}
\alias{log10,dual-method}
\alias{log2}
\alias{log2,dual-method}
\alias{log1p}
\alias{log1p,dual-method}
\alias{exp}
\alias{exp,dual-method}
\alias{expm1}
\alias{expm1,dual-method}
\title{Logarithms and Exponentials}
\usage{
\S4method{log}{dual}(x)

\S4method{logb}{dual,numeric}(x, base = exp(1))

\S4method{logb}{numeric,dual}(x, base = exp(1))

\S4method{logb}{dual,dual}(x, base = exp(1))

\S4method{log10}{dual}(x)

\S4method{log2}{dual}(x)

\S4method{log1p}{dual}(x)

\S4method{exp}{dual}(x)

\S4method{expm1}{dual}(x)
}
\arguments{
\item{x}{a dual object or numeric value.}

\item{base}{a dual object or a positive number. Defaults to \code{e=exp(1)}.}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
Logarithms and Exponentials
}
\examples{
x <- dual(sqrt(pi), 1:0)
y <- dual(pi * .75, 0:1)
log(x)
logb(x, base = 1.1)
logb(3.1, base = x)

logb(x, y)
log10(x)
log2(x)

log1p(x)

exp(2*x)
expm1(2*x)
}
