# Generated by 02-duckplyr_df-methods.R
#' @export
inner_join.duckplyr_df <- function(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ..., keep = NULL, na_matches = c("na", "never"), multiple = "all", unmatched = "drop", relationship = NULL) {
  check_dots_empty0(...)
  error_call <- caller_env()

  # Our implementation
  rel_try(
    "No implicit cross joins for inner_join()" = is_cross_by(by),
    "No relational implementation for inner_join(copy = TRUE)" = copy,
    {
      out <- rel_join_impl(x, y, by, "inner", na_matches, suffix, keep, error_call)
      return(out)
    }
  )

  # dplyr forward
  inner_join <- dplyr$inner_join.data.frame
  out <- inner_join(x, y, by, copy, suffix, ..., keep = keep, na_matches = na_matches, multiple = multiple, unmatched = unmatched, relationship = relationship)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)
  y <- auto_copy(x, y, copy = copy)
  join_mutate(
    x = x,
    y = y,
    by = by,
    type = "inner",
    suffix = suffix,
    na_matches = na_matches,
    keep = keep,
    multiple = multiple,
    unmatched = unmatched,
    relationship = relationship,
    user_env = caller_env()
  )
}

duckplyr_inner_join <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df(x)
      y <- as_duckplyr_df(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- inner_join(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
